<?php
// cms/api/surveys/list.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("eventid","order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $eventid=$_REQUEST["eventid"];
    // Seleccionar el evento activo y los idiomas disponibles
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE id=".$eventid;
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No existe ese evento"));
    
    $languages=explode(",",$rowevent["activelanguages"]);

    $outputlanguage = $rowevent["defaultlang"];
    isSessionValidCMS($db,$_REQUEST["sessionid"]);

    // order
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY S.name_".$outputlanguage.$type;
            break;
        case 2:
            $strorderby=" ORDER BY S.dsc_".$outputlanguage.$type;
            break;
        case 4:
            $strorderby=" ORDER BY S.id".$type;
            break; 
        case 5:
            $strorderby=" ORDER BY S.datecreated".$type;
            break;                
        default:
            badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
    }   

    $strorderby.=", SQ.ord, SQ.id ";

    // parametros opcionales
    //Se establece un filtro por el nombre y las descripciones
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= "UPPER(S.name_esp) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(S.name_eng) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(S.name_por) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(S.dsc_esp) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(S.dsc_eng) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(S.dsc_por) LIKE '%" . strtoupper($filtro[$i]) . "%' ";                        
            $filter .= ") ";
        }
    }
    else $filter="";



    $sql="SELECT S.id AS surveyid, S.name_esp,S.name_eng,S.name_por, S.dsc_esp AS surveydsc_esp, S.dsc_eng AS surveydsc_eng, S.dsc_por AS surveydsc_por, S.status AS surveystatus, SQ.id AS questionid, SQ.dsc_esp AS questiondsc, SQ.status AS questionstatus ".
        " FROM surveyquestions SQ RIGHT JOIN surveys S ON S.id=SQ.surveyid".
        " WHERE eventid=".$eventid;

    // Si hay filtro lo incluyo    
    if (strlen($filter)>0) 
        $sql= $sql." AND (".$filter.")";

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    
    // Se concatena el order by 
    $sql= $sql.$strorderby;
    
    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrec"];

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $surveys = array();
    $surveyact="";
    while ($row = $rs->fetch_assoc()){
        if ($surveyact<>$row["surveyid"]){
            if ($surveyact<>"") {
                if (is_null($questionact)) {
                    $survey->questions=array();
                    $surveys[]=$survey;
                }
                else {
                    $survey->questions[]=$question;
                    $surveys[]=$survey;
                }
            }
            $survey=new stdClass;
            $survey->id=(integer)$row["surveyid"];
            if (!is_null($row["name_".$outputlanguage]) && trim($row["name_".$outputlanguage])!="")
                $survey->name=$row["name_".$outputlanguage];
            elseif (!is_null($row["name_esp"]) && trim($row["name_esp"])!="")
                $survey->name=$row["name_esp"];
            elseif (!is_null($row["name_eng"]) && trim($row["name_eng"])!="")
                $survey->name=$row["name_eng"];
            elseif (!is_null($row["name_por"]) && trim($row["name_por"])!="")
                $survey->name=$row["name_por"];
            else
                $survey->name="";

            if (!is_null($row["surveydsc_".$outputlanguage]) && trim($row["surveydsc_".$outputlanguage])!="")
                $survey->dsc=$row["surveydsc_".$outputlanguage];
            elseif (!is_null($row["surveydsc_esp"]) && trim($row["surveydsc_esp"])!="")
                $survey->dsc=$row["surveydsc_esp"];
            elseif (!is_null($row["surveydsc_eng"]) && trim($row["surveydsc_eng"])!="")
                $survey->dsc=$row["surveydsc_eng"];
            elseif (!is_null($row["surveydsc_por"]) && trim($row["surveydsc_por"])!="")
                $survey->dsc=$row["surveydsc_por"];
            else
                $survey->dsc="";                

            $survey->status= new stdClass;
            if ($row["surveystatus"]==1) {
                $survey->status->id=1;
                $survey->status->dsc="Activo";
            }
            else {
                $survey->status->id=0;
                $survey->status->dsc="Inactivo";
            }
            
            if (!is_null($row["questionid"])) {
                $survey->questions=array();
                $questionact="";
            }
            else
                $questionact=$row["questionid"];
            $surveyact=$row["surveyid"];
        }
        
        if ($questionact <> $row["questionid"] && !is_null($row["questionid"])) {
            if ($questionact<>"") {
                $survey->questions[]=$question;
            }
            $question=new stdClass;
            $question->id=(integer)$row["questionid"];
            $question->dsc=nvl($row["questiondsc"],"");
            $question->status= new stdClass;
            if ($row["questionstatus"]==1) {
                $question->status->id=1;
                $question->status->dsc="Activo";
            }
            else {
                $question->status->id=0;
                $question->status->dsc="Inactivo";
            }
            $questionact=$row["questionid"];
        }

    }
    
    if ($surveyact<>"") {
        if (is_null($questionact)) {
            $survey->questions=array();
            $surveys[]=$survey;
        }
        else {
            $survey->questions[]=$question;
            $surveys[]=$survey;
        }
    }
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$surveys;
    //$out->sql=$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>