<?php
// app/api/sponsors/list.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("eventid","order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $eventid=$_REQUEST["eventid"];
    // Seleccionar el evento activo y los idiomas disponibles
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE id=".$eventid;
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No existe ese evento"));
    
    $languages=explode(",",$rowevent["activelanguages"]);

    $outputlanguage = $rowevent["defaultlang"];
    isSessionValidCMS($db,$_REQUEST["sessionid"]);

    // order
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY name".$type;
            break;
        case 2:
            $strorderby=" ORDER BY weight".$type;
            break;
        case 3:
            $strorderby=" ORDER BY datecreated".$type;
            break;
        default:
            badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
    }   


    // parametros opcionales
    //Se establece un filtro por el nombre y las descripciones
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= "UPPER(name) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(dsc_esp) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(dsc_eng) LIKE '%" . strtoupper($filtro[$i]) . "%' OR ";
            $filter .= "UPPER(dsc_por) LIKE '%" . strtoupper($filtro[$i]) . "%' ";                        
            $filter .= ") ";
        }
    }
    else $filter="";

    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= "UPPER(tags) LIKE '%" . strtoupper($tags[$i]) . "%'  ";
            $filtertag .= ") ";
        }
    }
    else $filtertag="";

    // activityid NO DEFINIDO
    //if (isset($_REQUEST["activityid"]))

    $sql="SELECT id, name, weight, imagetype, tags, dsc_esp, dsc_eng, dsc_por,  ".
        " email, website, facebook, twitter, instagram, linkedin " .
        " FROM sponsors ".
        " WHERE eventid=".$eventid;

    // Si hay filtro lo incluyo    
    if (strlen($filter)>0) 
        $sql= $sql." AND (".$filter.")";

    // Si hay filtro de tag lo incluyo    
    if (strlen($filtertag)>0) 
        $sql= $sql." AND (".$filtertag.")";

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    
    // Se concatena el order by 
    $sql= $sql.$strorderby;
    
    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrec"];

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name"],"");
        // Imagen
        if (!is_null($row["imagetype"]) && $row["imagetype"]!=="") {
            switch ($row["imagetype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
            }
            $record->image=$homeurl."uploads/sponsors/".$row["id"].$ext;
        }
        else
            $record->image="";
        // Fin imagen        
        $record->tags=nvl($row["tags"],"");            
        $record->dsc=$row["dsc_".$outputlanguage];
        $record->email=nvl($row["email"],"");
        $record->website=nvl($row["website"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
        $record->weight=nvl($row["weight"],"");
        
        $records[] = $record;
    }
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>