<?php
// app/api/reports/survey.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("surveyid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    

    // Seleccionar el evento correspondiente y los idiomas disponibles
    $sql = "SELECT eventid, activelanguages, defaultlang  "
    . "FROM surveys S "
    . "	INNER JOIN events E ON E.id=S.eventid "
    . "WHERE S.id=".$_REQUEST["surveyid"];



    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("400", array("msg"=>"Encuesta no disponible"));
    $eventid=$row["eventid"];
    $languages=explode(",",$row["activelanguages"]);
    $outputlanguage = $row["defaultlang"];

    //Validar sesion CMS
    isSessionValidCMS($db,$_REQUEST["sessionid"]);

    
    // query para el maximo valor tipo 1
    $sql = "SELECT "
    . "    O.questionid, "
    . "    SUM(A.Cnt) maxval "
    . "FROM "
    . "    ( "
    . "    SELECT "
    . "        O.questionid, "
    . "        O.id AS optionid, "
    . "        COUNT(*) Cnt "
    . "    FROM "
    . "        surveyoptions O "
    . "    INNER JOIN surveyresponses R ON "
    . "        R.responses = O.id WHERE R.closed=1"
    . "    GROUP BY "
    . "        O.questionid, "
    . "        O.id "
    . ") A "
    . "INNER JOIN surveyoptions O ON "
    . "    O.id = A.optionid "
    . "INNER JOIN surveyquestions Q ON "
    . "    Q.id = O.questionid "
    . "WHERE "
    . "    Q.surveyid=".$_REQUEST["surveyid"]." AND Q.type = 1  "
    . "GROUP BY "
    . "    O.questionid";
    
     $maxvalues_1 = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->questionid = $row["questionid"];
        $record->maxval = $row["maxval"];
         $maxvalues_1[] = $record;
    }    
    $lengthmaxvalues_1=count( $maxvalues_1);   
    
    // query para el maximo valor tipo 2
    $sql = "SELECT "
    . "    O.questionid, "
    . "    SUM(A.Cnt) maxval "
    . "FROM "
    . "    ( "
    . "    SELECT "
    . "        questionid, "
    . "        SO.id optionid, "
    . "        COUNT(SO.id) Cnt "
    . "    FROM "
    . "        surveyquestions SQ "
    . "    LEFT JOIN surveyresponses SR ON "
    . "        SR.surveyquestionid = SQ.id "
    . "    LEFT JOIN surveyoptions SO ON "
    . "        ( "
    . "            CONCAT('-', SR.responses, '-') LIKE CONCAT('%-', SO.id, '-%') "
    . "        ) "
    . "    WHERE "
    . "        SR.responses IS NOT NULL AND SQ.surveyid=".$_REQUEST["surveyid"]. " AND SQ.type = 2 AND SR.closed=1 "
    . "    GROUP BY "
    . "        questionid, "
    . "        SO.id "
    . ") A "
    . "INNER JOIN surveyoptions O ON "
    . "    O.id = A.optionid "
    . "INNER JOIN surveyquestions Q ON "
    . "    Q.id = O.questionid "
    . "WHERE "
    . "    Q.surveyid=".$_REQUEST["surveyid"]. " "
    . "GROUP BY O.questionid";

    $maxvalues_2 = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->questionid = $row["questionid"];
        $record->maxval = $row["maxval"];
         $maxvalues_2[] = $record;
    }    
    $lengthmaxvalues_2=count( $maxvalues_2);      
    // queries de los totales
  
    //answered
    $sql = "SELECT COUNT(DISTINCT S.id, SR.appuserid) answered "
    . "FROM  surveys S  "
    . "	LEFT JOIN surveyquestions SQ ON SQ.surveyid=S.id "
    . "	LEFT JOIN surveyresponses SR ON SR.surveyquestionid=SQ.id "
    . "WHERE S.id =".$_REQUEST['surveyid']." "
    . "AND SR.closed=1";
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if($row = $rs->fetch_assoc())
        $answered=$row["answered"];
    else
        $answered=0;
        
    //usuarios registrados en el evento
    $sql = "SELECT COUNT(DISTINCT(appuserid )) users "
    . "FROM  surveys S  "
    . "INNER JOIN appuserevent U ON U.eventid = S.eventid "
    . "WHERE S.id=".$_REQUEST['surveyid']." ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if($row = $rs->fetch_assoc())
        $userstotals=$row["users"];
    else
        $userstotals=0;    


    //usuarios que respondieron la encuesta
    $sql = "SELECT COUNT(DISTINCT(SR.appuserid )) AS users "
    . "	FROM  surveys S LEFT JOIN surveyquestions SQ ON SQ.surveyid=S.id "
    . "	LEFT JOIN surveyresponses SR ON SR.surveyquestionid=SQ.id "
    . "WHERE  S.id =".$_REQUEST['surveyid']." "
    . "AND SR.closed=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if($row = $rs->fetch_assoc())
        $users=$row["users"];
    else
        $users=0;

    // Información de la encuesta
    $sql = "SELECT S.id, S.name_esp, S.name_eng, S.name_por,  "
    . "S.dsc_esp, S.dsc_eng, S.dsc_por "
    . "FROM surveys S "
    . "WHERE S.id = ".$_REQUEST['surveyid']." ";

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    if(!$row = $rs->fetch_assoc())
        badEnd("400", array("msg"=>"No se encontró la encuesta"));    
    $surveyname=$row["name_".$outputlanguage];
    $surveydsc=$row["dsc_".$outputlanguage];
    

    //Opciones de cada pregunta
    $sql = "SELECT SO.questionid, SO.id as optionid, option_esp, option_eng, option_por  "
    . " FROM surveyoptions SO  "
    . " INNER JOIN surveyquestions SQ ON SQ.id=SO.questionid "
    . " WHERE SQ.surveyid = ".$_REQUEST["surveyid"]." ORDER BY SO.id";    
    
    $opciones = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->questionid = $row["questionid"];
        $record->optionid = $row["optionid"];
        $record->dsc = $row["option_".$outputlanguage];
        $opciones[] = $record;
    }    
    $arrlength=count($opciones);
    
    //Respuestas de cada opcion tipo 1
    $sql = "SELECT SQ.id questionid, SQ.dsc_".$outputlanguage.", SO.id optionid, SO.option_".$outputlanguage.", COUNT(*) responses "
    . "FROM  surveyquestions SQ  "
    . "LEFT JOIN surveyresponses SR ON SR.surveyquestionid=SQ.id "
    . "LEFT JOIN surveyoptions SO ON SO.id=SR.responses "
    . "WHERE SR.responses IS NOT NULL AND SQ.surveyid=".$_REQUEST["surveyid"]." "
    . "AND SQ.type=1 AND SR.closed=1 "
    . "GROUP BY SQ.id, SQ.dsc_esp, SO.option_esp ";
    
     $respuestas_1 = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->questionid = $row["questionid"];
        $record->optionid = $row["optionid"];
        $record->dsc = $row["option_".$outputlanguage];
        $record->responses=$row["responses"];
        $respuestas_1[] = $record;
    }    
    $arrlengthresp_1=count( $respuestas_1);
    
    //Respuestas de cada opcion tipo 2
    $sql = "SELECT SQ.id questionid, SQ.dsc_".$outputlanguage.", SO.id optionid, COUNT(*) responses  "
    . "     FROM  surveyquestions SQ   "
    . "     LEFT JOIN surveyresponses SR ON SR.surveyquestionid=SQ.id  "
    . "     LEFT JOIN surveyoptions SO ON (CONCAT('-' , SR.responses  , '-') LIKE CONCAT('%-' , SO.id , '-%'))  "
    . "     WHERE SR.responses IS NOT NULL AND SQ.surveyid=".$_REQUEST["surveyid"]." "
    . "     AND SQ.type=2 AND SR.closed=1 "
    . "     GROUP BY SQ.id, SO.id  ";
 

     $respuestas_2 = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->questionid = $row["questionid"];
        $record->optionid = $row["optionid"];
        $record->dsc = $row["option_".$outputlanguage];
        $record->responses=$row["responses"];
        $respuestas_2[] = $record;
    }    
    $arrlengthresp_2=count( $respuestas_2);

    

    $sql = "SELECT SQ.id questionid, SQ.type, SQ.dsc_esp, SQ.dsc_eng, SQ.dsc_por "
    . "FROM surveyquestions SQ  	 "
    . "WHERE SQ.surveyid=".$_REQUEST["surveyid"];

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    

    
    
    $records = array();
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->id = (integer)$row["questionid"];
        $record->type = (integer)$row["type"];
        $record->dsc = $row["dsc_".$outputlanguage];
        $record->maxval=0; 
        $total1=0;
        if ($row["type"]==1){
            for($x = 0; $x < $lengthmaxvalues_1; $x++) 
                if ( $maxvalues_1[$x]->questionid==$row["questionid"])
                    $total1=$total1+$maxvalues_1[$x]->maxval;
            if ($total1==0)        
                $record->maxval="100%";
            else
                $record->maxval=strval($total1/$total1*100)."%";
        }
        $total2=0;
        if ($row["type"]==2) {
            for($x = 0; $x < $lengthmaxvalues_2; $x++) {
                if ( $maxvalues_2[$x]->questionid==$row["questionid"])
                    $total2=$total2+$maxvalues_2[$x]->maxval; 
            }
            $record->maxval= $total2;   
        }
        if ($row["type"]==1) {
            $responses=array();
            for($x = 0; $x < $arrlength; $x++) {
                $estructura=new stdClass;
                if ($opciones[$x]->questionid==$row["questionid"]){
                    $estructura->option=$opciones[$x]->dsc;
                    $estructura->value=new stdClass;
                    $estructura->value->number=0;
                    $estructura->value->formatted="0";
                for($y = 0; $y < $arrlengthresp_1; $y++) 
                    if ($respuestas_1[$y]->questionid==$row["questionid"] && $respuestas_1[$y]->optionid==$opciones[$x]->optionid) {
                        $estructura->value->number=(integer)$respuestas_1[$y]->responses/$total1*100;
                        $estructura->value->formatted=number_format((integer)$respuestas_1[$y]->responses/$total1*100,2,",",".")."%";
                    }
                $responses[]=$estructura;                
                }
            }
        }
        if ($row["type"]==2) {
            $responses=array();
            for($x = 0; $x < $arrlength; $x++) {
                $estructura=new stdClass;
                if ($opciones[$x]->questionid==$row["questionid"]){
                    $estructura->option=$opciones[$x]->dsc;
                    $estructura->value=new stdClass;
                    $estructura->value->number=0;
                    $estructura->value->formatted="0";
                for($y = 0; $y < $arrlengthresp_2; $y++) 
                    if ($respuestas_2[$y]->questionid==$row["questionid"] && $respuestas_2[$y]->optionid==$opciones[$x]->optionid) {
                        $estructura->value->number=(integer)$respuestas_2[$y]->responses;
                        $estructura->value->formatted=$respuestas_2[$y]->responses;
                    }
                $responses[]=$estructura;                
                }
            }
        }        
        
        $record->options=$responses;
        $records[] = $record;
    }

    
    $out= new stdClass;
    $out->totals=new stdClass;
    $out->totals->answered=new stdClass;
    $out->totals->answered->number =(integer)$answered;
    $out->totals->answered->formatted =$answered;
    $out->totals->users =new stdClass;
    $out->totals->users->number =$users*100/$userstotals;
    $out->totals->users->formatted =number_format($users*100/$userstotals,2,",",".")."%";
    $out->survey=new stdClass;
    $out->survey->id=$_REQUEST['surveyid'];
    $out->survey->name=$surveyname;
    $out->survey->dsc=$surveydsc;
    $out->questions=$records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>