<?php
// docs/upload2

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","uploadids");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array(msg=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sessionid = $_GET["sessionid"];
    
    $id = isSessionValid($db, $sessionid);
    
    $cnt = 0;
    $archivos = explode("-", $_REQUEST["uploadids"]);
    foreach($archivos as $archivo){
        if (isset($_FILES[$archivo])){
            if (!$_FILES[$archivo]["tmp_name"])
                badEnd("500", array(id=>0,msg=>"Archivo ".$archivo." no enviado"));
            switch ($_FILES[$archivo]["type"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array(id=>1,msg=>"El formato del documento debe ser PNG o JPG"));
            }
            if (!file_exists('../../uploads/useruploads/'.$id)) {
                if (!@mkdir('../../uploads/useruploads/'.$id)){
                    $error = error_get_last();
                    badEnd("500", array(id=>2,msg=>$error['message']));
                }
            }
            if(move_uploaded_file($_FILES[$archivo]["tmp_name"], '../../uploads/useruploads/'.$id."/".$archivo.$ext)){
                // se borra la carga anterio de existir
                $sql = "DELETE FROM useruploads WHERE userid=".$id." AND cmsprefuploadid=".$archivo;
                if (!$db->query($sql))
                    badEnd("500", array(sql=>$sql,msg=>$db->error));
                // se inserta el registro de la image subida
                $sql =  "INSERT INTO useruploads (userid, cmsprefuploadid, filename, filetype, validated) " .
                        "VALUES ('" . $id . "'," .
                        "        '" . $archivo . "'," .
                        "        '" . $archivo.$ext . "'," .
                        "        '" . $_FILES[$archivo]["type"] . "'," .
                        "        0)";
                if (!$db->query($sql))
                    badEnd("500", array(sql=>$sql,msg=>$db->error));
                setAudit($db, "UPLOAD", $sessionid, "Se subio el archivo ".$archivo." para el usuario " . $id);
                $cnt++;
            } else {
                badEnd("500", array(id=>2,msg=>"Error en funcion move_uploaded_file"));
            }
        }

    }
    
    $out->uploadedfiles = (integer) $cnt;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
