<?php
// cms/api/demographics/listtimezones.php

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    

    $sql = "SELECT C.name AS countryname, C.code AS countrycode, Z.name AS zonename, Z.id AS zonecode, "
    . "FROM_UNIXTIME(UNIX_TIMESTAMP(UTC_TIMESTAMP()) + TZ.gmt_offset, '%a, %d %b %Y, %H:%i:%s') AS local_time "
    . "FROM "
    . "    utc_zones Z "
    . "    INNER JOIN utc_timezones TZ ON TZ.utc_zoneid=Z.id "
    . "    INNER JOIN countries C ON C.code = Z.countrycode "
    . "    INNER JOIN  "
    . "        (SELECT C.code AS countrycode, Z.id AS zoneid,  MAX(TZ.time_start) AS time_start "
    . "        FROM utc_timezones tz "
    . "        INNER JOIN utc_zones z ON tz.utc_zoneid=z.id "
    . "        INNER JOIN countries C ON C.code= Z.countrycode "
    . "        WHERE tz.time_start <= UNIX_TIMESTAMP(UTC_TIMESTAMP())  "
    . "        GROUP BY C.name, z.name "
    . "        ORDER BY C.name, z.name) A "
    . "ON A.time_start=tz.time_start AND A.countrycode=Z.countrycode AND A.zoneid=TZ.utc_zoneid "
    . "WHERE tz.time_start <= UNIX_TIMESTAMP(UTC_TIMESTAMP())  "
    . "ORDER BY zonename";

    
    $sqlCnt= "SELECT COUNT(*) Cnt FROM ( ".$sql.") A";
    if (!$rs = $db->query($sqlCnt))
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $numofrecords=$row["Cnt"];
    
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $records=array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->country = new stdClass;
        $record->country->code=$row["countrycode"];
        $record->country->name=$row["countryname"];
        $record->zone=new stdClass;
        $record->zone->code=$row["zonecode"];
        $record->zone->name=$row["zonename"];
        $records[] = $record;
    }

    $out= new stdClass;
    $out->numofrecords = (integer)$numofrecords;
    $out->records = $records;
    $out->sql=$sql;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>

