<?php
// cms/activities/update

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("id","eventid","siteid","from","to","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    $columns="id,eventid,siteid,datefrom,dateto";
    $values=$_REQUEST["id"].",".$_REQUEST["eventid"].",".$_REQUEST["siteid"].",'".$_REQUEST["from"]."','".$_REQUEST["to"]."'";
    $updatelist ="eventid=".$_REQUEST["eventid"].",siteid=".$_REQUEST["siteid"].",datefrom='".$_REQUEST["from"]."'".
                ",dateto='".$_REQUEST["to"]."'";
                
    //** Al menos uno de los nombres debe venir con datos
    if (!isset($_REQUEST["name_esp"]) && !isset($_REQUEST["name_eng"]) && !isset($_REQUEST["name_por"]))
        badEnd("401", array("msg"=>"No se permite que todos los nombres sean NULL"));
    else {
        $nameesp=nvl($_REQUEST["name_esp"],"");
        $nameeng=nvl($_REQUEST["name_eng"],"");
        $namepor=nvl($_REQUEST["name_por"],"");
        if ((strlen($nameesp)+strlen($nameeng)+strlen($namepor))==0)
            badEnd("401", array("msg"=>"No se permite que todas las descripciones sean vacías"));
    }
    //**

    //** Al menos una de las descripciones debe venir con datos
    if (!isset($_REQUEST["dsc_esp"]) && !isset($_REQUEST["dsc_eng"]) && !isset($_REQUEST["dsc_por"]))
        badEnd("401", array("msg"=>"No se permite que todas las descripciones sean NULL"));
    else {
        $dscesp=nvl($_REQUEST["dsc_esp"],"");
        $dsceng=nvl($_REQUEST["dsc_eng"],"");
        $dscpor=nvl($_REQUEST["dsc_por"],"");
        if ((strlen($dscesp)+strlen($dsceng)+strlen($dscpor))==0)
            badEnd("401", array("msg"=>"No se permite que todas las descripciones sean vacías"));
    }
    //**

    
    if (isset($_REQUEST["tags"])){
        $columns = $columns.",tags";
        $values = $values.",'".$_REQUEST["tags"]."'";
        $updatelist = $updatelist.",tags='".$_REQUEST["tags"]."'";
    }
    if (isset($_REQUEST["dsc_eng"]) && trim($_REQUEST["dsc_eng"])!=""){
        $columns = $columns.",dsc_eng";
        $values = $values.",'".str_replace("'","''",$_REQUEST["dsc_eng"])."'";
        $updatelist = $updatelist.",dsc_eng='".str_replace("'","''",$_REQUEST["dsc_eng"])."'";
    }
    if (isset($_REQUEST["dsc_esp"]) && trim($_REQUEST["dsc_esp"])!=""){
        $columns = $columns.",dsc_esp";
        $values = $values.",'".str_replace("'","''",$_REQUEST["dsc_esp"])."'";
        $updatelist = $updatelist.",dsc_esp='".str_replace("'","''",$_REQUEST["dsc_esp"])."'";
    }
    if (isset($_REQUEST["dsc_por"]) && trim($_REQUEST["dsc_por"])!=""){
        $columns = $columns.",dsc_por";
        $values = $values.",'".str_replace("'","''",$_REQUEST["dsc_por"])."'";
        $updatelist = $updatelist.",dsc_por='".str_replace("'","''",$_REQUEST["dsc_por"])."'";
    }
    
    if (isset($_REQUEST["name_eng"]) && trim($_REQUEST["name_eng"])!=""){
        $columns = $columns.",name_eng";
        $values = $values.",'".$_REQUEST["name_eng"]."'";
        $updatelist = $updatelist.",name_eng='".$_REQUEST["name_eng"]."'";
    }
    if (isset($_REQUEST["name_esp"]) && trim($_REQUEST["name_esp"])!=""){
        $columns = $columns.",name_esp";
        $values = $values.",'".$_REQUEST["name_esp"]."'";
        $updatelist = $updatelist.",name_esp='".$_REQUEST["name_esp"]."'";
    }
    if (isset($_REQUEST["name_por"]) && trim($_REQUEST["name_por"])!=""){
        $columns = $columns.",name_por";
        $values = $values.",'".$_REQUEST["name_por"]."'";
        $updatelist = $updatelist.",name_por='".$_REQUEST["name_por"]."'";
    }    

    //** Identificar si es INSERT o es UPDATE
    if ($_REQUEST["id"]==0) { 
        // Es un insert
        $sql="INSERT INTO activities (".$columns.") VALUES (".$values.")";
        if (!$db->query($sql)) {
            if ($db->errno == 1062){
                badEnd("304", array("msg"=>"Registro Duplicado"));
            }
            else {
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
        }
        $activityid =$db->insert_id;
    }
    else {
        // Es un update
        // Validar que existe el registro
        $sql="SELECT COUNT(*) Cnt FROM activities WHERE id=".$_REQUEST["id"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $row = $rs->fetch_assoc();
        if ($row["Cnt"]==0)
            badEnd("204", array("msg"=>"El registro no existe"));
        $sql="UPDATE activities SET ".$updatelist." WHERE id=".$_REQUEST["id"];
        if (!$db->query($sql)) 
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $activityid=$_REQUEST["id"];    
    }
    if (!isset($activityid))
        $activityid=$_REQUEST["id"]; 

    //** Actualizar panelistas
    if (isset($_REQUEST["panelistids"])) {
        // Se borran todos los panelistas asociados a la actividad
        $sql="DELETE FROM activitypanelists WHERE activityid=".$activityid ;
        if (!$db->query($sql)) 
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        // Se insertan todos los panelistas de la lista asociados a la actividad
        $arraypanelistids=explode("-",$_REQUEST["panelistids"]);
        foreach($arraypanelistids as $value) {
            $sql="INSERT INTO activitypanelists (activityid, panelistid) ".
                "VALUES ($activityid, $value) ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }
    }
    //**


    // ------ Cargar archivo de attachments
    $attids=array();
    $attnames=array();
    $atttypes=array();
    
    if (isset($_REQUEST["attachmentids"])) 
        $attids=explode("-",$_REQUEST["attachmentids"]);
    if (isset($_REQUEST["attachmentnames"])) 
        $attnames=explode("|",$_REQUEST["attachmentnames"]);
    if (isset($_REQUEST["attachmenttypes"])) 
        $atttypes=explode("-",$_REQUEST["attachmenttypes"]);


    if (count($attids)<>count($attnames) || count($attids)<>count($atttypes)) 
        badEnd("400", array("msg"=>"El numero de ids no coincide con el numero de nombres o tipos"));

    if (isset($_REQUEST["attachmentids"]) && count($attids)>0) {
  
        //$newattachments guarda los indices de los mimes nuevos que son tipo 1 (archivos)
        $newattachments=array();
        $arrlength = count($attids);
        for($x = 0; $x < $arrlength; $x++) 
            if($attids[$x]==0 && $atttypes[$x]==1) 
                $newattachments[]=$x;
        if (count($_FILES)<>count($newattachments))
            badEnd("400", array("msg"=>"La cantidad de attachments cargados no es igual a la cantidad de attachments nuevos indicados con ceros"));
        $attachments= array();
        //Si no existe el directorio de la activity para los attachments, se crea
        $dir='../../uploads/activities/'.$activityid;
        if (!file_exists($dir)) {
            if (!@mkdir($dir))
                badEnd("500", array(id=>2,msg=>$error['message']));
        }
        //Si existe, busco un listado de los archivos del directorio
        else {
            $a = scandir($dir);
            //Lleno el arreglo de estructura con datos de los archivos, todos son candidatos a borrar
            for($i=2; $i<count($a); $i++) {
                $attobj= new stdClass;
                $attobj->id=(integer)substr($a[$i], 0, strpos($a[$i], '.'));
                $ext=substr($a[$i], strpos($a[$i], '.')+1);
                $attobj->type="image/".$ext;
                $attobj->url="../../uploads/activities/".$_REQUEST["id"]."/".$attobj->id.".".$ext;
                $attobj->todelete=true;
                $attachments[]=$attobj;
            }
        }
        //En caso de que existan mimes los busco y las marco para no borrar
        if (count($attachments)>0) {
            foreach ($attachments as $value) {
                foreach ($attids as $x) {
                    if ($value->id==$x) {
                        $value->todelete=false;
                        break;
                    }
                }
            }
            //Borrar los marcados del directorio los que son tipo 1
            $idsfordelete="";
            foreach($attachments as $value) {
                if ($value->todelete) {
                    if (strlen($idsfordelete)<>0)
                        $idsfordelete.=",";
                    $idsfordelete.=$value->id;
                    $source=$dir."/".$value->id.".".substr($value->type,-3);
                    if (!unlink($source))
                        badEnd("500", array("id"=>3,"msg"=>$error['message']));
                }
            }
            //Borrar los tipo 1 marcados de la BD
            if (strlen($idsfordelete)<>0) {
                $sql="DELETE FROM activityattachments WHERE id IN ($idsfordelete)";
                if (!$db->query($sql))
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
        }        

        //Grabar mimes nuevos
        if (count($newattachments)>0) {        
            $i=1;
            foreach ($newattachments as $index) {
                $FILE="FILE".$i++;
                if (isset($_FILES[$FILE])){
                    if (!$_FILES[$FILE]["tmp_name"])
                        badEnd("500", array("id"=>0,"msg"=>"Archivo no enviado"));
                    switch ($_FILES[$FILE]["type"]){
                        case "application/pdf":
                            $ext = ".pdf";
                            break;
                        case "text/html":
                            $ext = ".html";
                            break;
                        case "image/png":
                            $ext = ".png";
                            break;                            
                        case "image/jpeg":
                            $ext = ".jpg";
                            break;
                        case "image/jpg":
                            $ext = ".jpg";
                            break;
                        default:
                            badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG, JPG, html o pdf"));
                    }
                    $mimetype=$_FILES[$FILE]["type"];
                    // Grabar datos del mime en la BD
                    $extbd=substr($attnames[$index], strpos($attnames[$index], '.')+1);
                    if ($extbd=='jpeg')
                        $filename=substr($attnames[$index],0, strpos($attnames[$index], '.')).".jpg";
                    else
                        $filename=$attnames[$index];
                    $sql="INSERT INTO activityattachments (id, type, name, mimetype, activityid) ".
                        "VALUES (0, '$atttypes[$index]', '$filename','$mimetype',$activityid)";
                    if (!$db->query($sql)) {
                        if ($db->errno == 1062)
                            badEnd("304", array("msg"=>"Registro Duplicado"));
                        else 
                            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
                    }
                    $mimeid =$db->insert_id;                        
                    // Grabar los archivos en el directorio                        
                    $ruta='../../uploads/activities/'.$activityid.'/'.$mimeid.$ext;
                    if(!move_uploaded_file($_FILES[$FILE]["tmp_name"], $ruta))
                        badEnd("500", array("id"=>3,"msg"=>"Error en funcion move_uploaded_file"));
                }
            }
        }

       //Actualizar los nombres y tipos de los mimes viejos
        $arrlength = count($attids);
        for($x = 0; $x < $arrlength; $x++) {
            if($attids[$x]<>0) {
                $sql="UPDATE activityattachments SET name='$attnames[$x]' WHERE id=$attids[$x]";
                if (!$db->query($sql)) 
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
        }
        //Insertar mimes tipo 2 URL
        $idstipo2="";
        for($x = 0; $x < $arrlength; $x++) { 
            if($attids[$x]==0 && $atttypes[$x]==2) {
                $sql="INSERT INTO activityattachments (id, type, name, mimetype, activityid) ".
                    "VALUES (0, '$atttypes[$x]', '$attnames[$x]',NULL,$activityid)";
                if (!$db->query($sql)) {
                    if ($db->errno == 1062)
                        badEnd("304", array("msg"=>"Registro Duplicado"));
                    else 
                        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
                }  
                if (strlen($idstipo2)<>0)
                    $idstipo2.=",";
                $idstipo2.=$db->insert_id;
            }               
        }
        // Borrar los tipo 2 de la BD
        for($x = 0; $x < $arrlength; $x++) {
            if($attids[$x]<>0 && $atttypes[$x]==2) {
                if (strlen($idstipo2)<>0)
                    $idstipo2.=",";
                $idstipo2.=$attids[$x];
            }
        }
        $sql="DELETE FROM activityattachments WHERE activityid=$activityid ".
            " AND type=2 ";
        if (strlen($idstipo2)<>0) 
            $sql.=" AND id NOT IN ($idstipo2)";
        if (!$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    //------ Fin Cargar archivos mime 

    //------ Actualizar Cache
    $eventid=$_REQUEST["eventid"];
    
    if(!actualizarCache($db,$eventid,'event', 0)) 
        badEnd("500", array("msg"=>"Error actualizando cache"));
    //------Fin Actualizar Cache  

    $out = new stdClass;    
    $out->id =(integer)$activityid;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>