<?php
// cms/api/surveys/entry.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
   

    $sql="SELECT S.id AS surveyid, S.name_esp, S.name_eng, S.name_por, S.dsc_esp AS survey_esp, ".
            "S.dsc_eng AS survey_eng, S.dsc_por AS survey_por, S.status AS surveystatus, ".
            "SQ.id AS questionid, SQ.dsc_esp AS question_esp, SQ.dsc_eng AS question_eng, ".
            "SQ.dsc_por AS question_por, SQ.status AS questionstatus, SQ.type AS type, ".
            "SO.id AS optionid, SO.option_esp, SO.option_eng, SO.option_por ".
            "FROM surveyquestions SQ RIGHT JOIN surveys S ON S.id=SQ.surveyid ".
            "LEFT JOIN surveyoptions SO ON SO.questionid=SQ.id ".
            "WHERE S.id=".$_REQUEST["id"]. " ".
            "ORDER BY surveyid, SQ.ord, SQ.id, SO.id  ";

    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    //$surveys = array();
    $surveyact="";
    while ($row = $rs->fetch_assoc()){
        if ($surveyact<>$row["surveyid"]){
            if ($surveyact<>"") {
                $survey->questions[]=$question;
            }
            $survey=new stdClass;
            $survey->id=(integer)$row["surveyid"];
            $survey->name= new stdClass;
            $surveynames=array('esp'=>nvl($row["name_esp"],""),'eng'=>nvl($row["name_eng"],""),'por'=>nvl($row["name_por"],""));
            $survey->name=$surveynames;
            $surveydsc=array('esp'=>nvl($row["survey_esp"],""),'eng'=>nvl($row["survey_eng"],""),'por'=>nvl($row["survey_por"],""));
            $survey->dsc=$surveydsc;
            $survey->status= new stdClass;
            if ($row["surveystatus"]==1) {
                $survey->status->id=1;
                $survey->status->dsc="Activo";
            }
            else {
                $survey->status->id=0;
                $survey->status->dsc="Inactivo";
            }
            $survey->questions=array();
            $questionact="";
            $surveyact=$row["surveyid"];
        }
        if ($questionact <> $row["questionid"]) {
            if ($questionact<>"") {
                $survey->questions[]=$question;
            }
            $question=new stdClass;
            $question->id=(integer)$row["questionid"];
            $question->type=(integer)$row["type"];
            $questiondsc=array('esp'=>nvl($row["question_esp"],""),'eng'=>nvl($row["question_eng"],""),'por'=>nvl($row["question_por"],""));
            $question->dsc=$questiondsc;
            $question->status= new stdClass;
            if ($row["questionstatus"]==1) {
                $question->status->id=1;
                $question->status->dsc="Activo";
            }
            else {
                $question->status->id=0;
                $question->status->dsc="Inactivo";
            }
            $question->options=array();
            $questionact=$row["questionid"];
        }

        $option=new stdClass;
        $option->id=(integer)$row["optionid"];
        $optiondsc=array('esp'=>nvl($row["option_esp"],""),'eng'=>nvl($row["option_eng"],""),'por'=>nvl($row["option_por"],""));
        $option->dsc=$optiondsc;
        if ($row["optionid"]<>0)
            $question->options[]=$option;
        else 
            $survey->questions=array();
    }
    if ($surveyact<>"") {
        $survey->questions[]=$question;
        if (is_null($question))
            $survey->questions=array();
    }


    $out= new stdClass;
    $out->entry =nvl($survey,array());
    //$out->sql=$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>