<?php
// app/api/reports/visitstagslist.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("eventid","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    $eventid=$_REQUEST["eventid"];
    
    //Validar sesion CMS
    isSessionValidCMS($db,$_REQUEST["sessionid"]);


    $sql = "SELECT tags " .
        " FROM activities ".
        " WHERE eventid=".$_REQUEST["eventid"]; 
    $sql.=" UNION (SELECT tags " .
        " FROM panelists ".
        " WHERE eventid=".$_REQUEST["eventid"].")";
    $sql.=" UNION (SELECT tags " .
        " FROM sites ".
        " WHERE eventid=".$_REQUEST["eventid"].")";
    $sql.=" UNION (SELECT tags " .
        " FROM sponsors ".
        " WHERE eventid=".$_REQUEST["eventid"].")";



    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $records = array();
    while ($row = $rs->fetch_assoc()){
        $breaktags = explode(" ",$row["tags"]);
        foreach ($breaktags as $valor) 
            $records[] = $valor;
    }
    //Lleno nuevo arreglo sin los repetidos
    $uniquerecords = array_unique($records);

    //Lleno arreglo con etiquetas que cumplan el filtro
    if (isset($_REQUEST["filter"])) {
        if (substr($_REQUEST["filter"],0,1)<>"#")
            badEnd("400", array("msg"=>"El filtro debe empezar por numeral o debe ser NULL"));
        $recordsfilter = array();    
        foreach ($records as $valor) 
            if (substr_count(strtoupper($valor),strtoupper($_REQUEST["filter"]),0)>0)
                $recordsfilter[]=$valor;
        //Lleno nuevo arreglo sin los repetidos
        $uniquerecordsfilter = array_unique($recordsfilter);
    }

    $out= new stdClass;
    $out->sql =$sql;
    if (isset($uniquerecordsfilter)) {
        $taglistfilter=array();
        foreach ($uniquerecordsfilter as $x)
            $taglistfilter[]=$x;
        $out->numofrecords=count($uniquerecordsfilter);
        $out->records = $taglistfilter;
    }
    else {
        $taglist=array();
        foreach ($uniquerecords as $x)
            $taglist[]=$x;
        $out->numofrecords=count($uniquerecords);
        $out->records = $taglist;
    }
    
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>