<?php
// app/api/reports/ratings.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("content","eventid","order","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    $eventid=$_REQUEST["eventid"];
    
    //Validar sesion CMS
    isSessionValidCMS($db,$_REQUEST["sessionid"]);

    if ($_REQUEST["content"]!=1)
        badEnd("400", array('msg'=>"El valor del campo content no está permitido"));

    // order
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY activityname".$type;
            break;
        case 2:
            $strorderby=" ORDER BY CntVotes".$type;
            break;
        case 3:
            $strorderby=" ORDER BY AvgRating".$type;
            break;
        default:
            badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
    }   

    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= "UPPER(tags) LIKE '%" . strtoupper($tags[$i]) . "%'  ";
            $filtertag .= ") ";
        }
        $filtertag =" AND ".$filtertag;
    }
    else $filtertag="";


    //Query para sacar el maxvalue por dia
    $sql = "SELECT "
    . "    DATE_FORMAT(AR.datecreated, '%Y-%m-%d') AS DATE, "
    . "    COUNT(DATE_FORMAT(AR.datecreated, '%Y-%m-%d')) AS CntVotes "
    . "FROM "
    . "    activityratings AR "
    . "INNER JOIN activities A ON "
    . "    A.id = AR.activityid "
    . "WHERE "
    . "    A.eventid = $eventid "
    . "GROUP BY "
    . "    DATE_FORMAT(AR.datecreated, '%d %b %y')";    
    $maxvalue = 0;
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        if ($row["CntVotes"]>$maxvalue)
            $maxvalue=$row["CntVotes"];
    }     

    $sql = "SELECT "
    . "    DATE_FORMAT(AR.datecreated, '%Y-%m-%d') AS date, "
    . "    AR.activityid, A.name_esp AS activityname,  "
    . "    COUNT(DATE_FORMAT(AR.datecreated, '%Y-%m-%d')) AS CntVotes  "
    . "FROM "
    . "    activityratings AR "
    . "INNER JOIN activities A ON "
    . "    A.id = AR.activityid "
    . "WHERE "
    . "    A.eventid = $eventid ".$filtertag." "
    . "GROUP BY "
    . "    DATE_FORMAT(AR.datecreated, '%d %b %y'), "
    . "    AR.activityid "
    . "ORDER BY "
    . "    AR.datecreated";    

    $bar = array();
    $bardate=array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));  
    $fecha='';
    while($row = $rs->fetch_assoc()) {
        if ($fecha=='') 
            $fecha='date'.$row["date"];
        if ($fecha == 'date'.$row["date"]){
            $record= new stdClass;
            $record->activity = new stdClass;
            $record->activity->id=$row["activityid"];
            $record->activity->name = $row["activityname"];
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["CntVotes"];
            $record->qty->formatted=number_format($row["CntVotes"],0,",",".");
            $bar[] = $record;
            $fecha='date'.$row["date"];
        }
        else {
            $bardate[$fecha]=$bar;
            unset($bar);
            $record= new stdClass;
            $record->activity = new stdClass;
            $record->activity->id=$row["activityid"];
            $record->activity->name = $row["activityname"];
            $record->qty = new stdClass;
            $record->qty->number=(integer)$row["CntVotes"];
            $record->qty->formatted=number_format($row["CntVotes"],0,",",".");
            $bar[] = $record;
            $fecha='date'.$row["date"];
        }
    }
    $bardate[$fecha]=$bar;
    unset($bar);

    $sql = "SELECT "
    . "    DATE_FORMAT(AR.datecreated, '%d %b %y') AS formatted , DATE_FORMAT(AR.datecreated, '%Y-%m-%d') AS date, "
    . "    AR.activityid, "
    . "    A.name_esp AS activityname "
    . "FROM "
    . "    activityratings AR "
    . "INNER JOIN activities A ON "
    . "    A.id = AR.activityid "
    . "WHERE "
    . "    A.eventid = $eventid ".$filtertag." "
    . "GROUP BY "
    . "    DATE_FORMAT(AR.datecreated, '%d %b %y') ORDER BY AR.datecreated ";

    $days = array();
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));    
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->day = new stdClass;
        $record->day->date = $row["date"];
        $record->day->formatted = $row["formatted"];
        $record->bar=$bardate['date'.$row["date"]];
        $days[] = $record;
    }    
    
    $sql = "SELECT "
    . "    AR.activityid, "
    . "    A.name_esp AS activityname, "
    . "    COUNT(*) AS CntVotes, "
    . "    AVG(AR.rating) AS AvgRating "
    . "FROM "
    . "    activityratings AR "
    . "INNER JOIN activities A ON "
    . "    A.id = AR.activityid "
    . "WHERE "
    . "    A.eventid = $eventid ".$filtertag." "
    . "GROUP BY "
    . "    AR.activityid, "
    . "    A.name_esp "
    .$strorderby;

   

    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));   
        
    $records = array();
    while($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->activity = new stdClass;
        $record->activity->id=(integer)$row["activityid"];
        $record->activity->name=$row["activityname"];

        $record->qty = new stdClass;
        $record->qty->number=(integer)$row["CntVotes"];
        $record->qty->formatted=number_format($row["CntVotes"],0,",",".");

        $record->avg = new stdClass;
        $record->avg->number=(float)$row["AvgRating"];
        $record->avg->formatted=number_format($row["AvgRating"],2,",",".");
        
        /*
        $record->participation = new stdClass;        
        $record->participation->maxval=new stdClass;
        $record->participation->maxval->number=(integer)$maxvalue;
        $record->participation->maxval->formatted=number_format($maxvalue,0,",",".");
        
        $record->participation->days= $days;
        */
        $records[] = $record;
    }

    $out= new stdClass;
    $out->activities= $records;
    
    //Movido para acá
    $out->participation = new stdClass;        
    $out->participation->maxval=new stdClass;
    $out->participation->maxval->number=(integer)$maxvalue;
    $out->participation->maxval->formatted=number_format($maxvalue,0,",",".");
        
    $out->participation->days= $days;
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>