<?php
// cms/api/panelists/entry

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("id","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    //**Se buscan las actividades asociadas a ese panelista
    $sql="SELECT A.id, A.name_esp FROM activities A INNER JOIN activitypanelists AP ON AP.activityid=A.id WHERE AP.panelistid=".$_REQUEST["id"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $arrayactivities=array();
    while ($row = $rs->fetch_assoc()) {
        $activity = new stdClass;
        $activity->id=$row["id"];
        $activity->name=$row["name"];
        $arrayactivities[]=$activity;
    }
    //**


    //Query principal
    $sql="SELECT id, name, surname, imagetype, tags, company, ".
        " position_esp, position_eng, position_por, dsc_esp, dsc_eng, dsc_por, ".
        " email, website, facebook, twitter, instagram, linkedin " .
        " FROM panelists ".
        " WHERE id=".$_REQUEST["id"];
    
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name"],"");
        $record->surname=nvl($row["surname"],"");
        // Imagen
        if (!is_null($row["imagetype"])) {
            switch ($row["imagetype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array(id=>1,msg=>"El formato del documento debe ser PNG o JPG"));
            }
            $record->image="./uploads/panelists/".$row["id"].$ext;
        }
        else
            $record->image="";
        // Fin imagen        
        $record->tags=nvl($row["tags"],"");            
        $record->company=nvl($row["company"],"");
        $arrayposition=array("esp"=>nvl($row["position_esp"],""), "eng"=>nvl($row["position_eng"],""), "por"=>nvl($row["position_por"],""));
        $record->position=$arrayposition;
        $arraydsc=array("esp"=>nvl($row["dsc_esp"],""), "eng"=>nvl($row["dsc_eng"],""), "por"=>nvl($row["dsc_por"],""));
        $record->dsc=$arraydsc;
        $record->email=nvl($row["email"],"");
        $record->website=nvl($row["website"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
        $record->activites=$arrayactivities;
    }
    
    $out= new stdClass;
    $out->entry=$record;
    //$out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>