<?php
// cms/api/messages/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("eventid","order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
     //Buscar la zona horaria del evento
    $sql = "SELECT E.utc_zoneid, Z.name FROM events E INNER JOIN utc_zones Z ON Z.id = E.utc_zoneid WHERE E.id=".$_REQUEST["eventid"];   
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())    
        badEnd("400", array("msg"=>"Evento no registrado"));
    $zonename=$row["name"];
    //
    
    // filtro
    // parametros opcionales
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= " message_esp LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= " message_eng LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= " message_por LIKE '%" . $filtro[$i] . "%' ";                        
            $filter .= ") ";
        }
        $filter = " AND ".$filter;
    }
    else $filter="";

    $sql = "SELECT id, sent, message_esp, message_eng, message_por, DATE_FORMAT(date,'%Y-%m-%d %H:%i') date,  "
        . "DATE_FORMAT(date,'%d/%m/%Y %h:%i %p') formatted "    
        . "FROM messages WHERE eventid =".$_REQUEST["eventid"].$filter;  
        
    $sqlCnt = "SELECT COUNT(*) Cnt FROM (".$sql.") A";    
    if (!$rs=$db->query($sqlCnt))
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $numofrecords=$row["Cnt"];


    // order
    $strorderby="";
    if ($_REQUEST["order"]>0)
        $type=' ASC ';
    else $type=' DESC ';
    switch (abs($_REQUEST["order"])) {
        case 1:
            $strorderby=" ORDER BY date ".$type;
            break;
        case 2:
            if (!is_null($_REQUEST["message_esp"]) && trim($_REQUEST["message_esp"])<>"")
                $strorderby=" ORDER BY message_esp ".$type." ";
            elseif (!is_null($_REQUEST["message_eng"]) && trim($_REQUEST["message_eng"])<>"")    
                $strorderby=" ORDER BY message_eng ".$type." ";
                elseif (!is_null($_REQUEST["message_por"]) && trim($_REQUEST["message_por"])<>"")    
                    $strorderby=" ORDER BY message_por ".$type." ";
            break;
        default:
            badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
    }   

    $sql = $sql.$strorderby;
    
    $sql = $sql . " LIMIT ".$_REQUEST["offset"].",".$_REQUEST["numofrec"];
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $records=array();    
    while ($row = $rs->fetch_assoc()) {
        $record= new stdClass;
        $record->id=(integer)$row["id"];
        $record->message=new stdClass;
        $record->message->esp=nvl($row["message_esp"],"");
        $record->message->eng=nvl($row["message_eng"],"");
        $record->message->por=nvl($row["message_por"],"");
        $record->date=new stdClass;
        $record->date->date=$row["date"];
        $record->date->formatted=$row["formatted"];

    //Validar que la fecha de envío sea superior a la actual
        $fecha_hora=explode(" ",$row["date"]);
        $fecha=$fecha_hora[0];
        $hora=$fecha_hora[1];
        $hms=explode(":",$hora);
        $strhora=" ".$hms[0]." hours ";
        $strmin=" ".$hms[1]. " minutes ";
        $time=strtotime($fecha.$strhora.$strmin);
        if (time()>convertirHora($db,$zonename,$time) || $row["sent"]==1) 
            $record->editable=false;
        else
            $record->editable=true;
    //FIN

        $record->sent=$row["sent"];
        $records[] = $record;       
    }
  
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    //$out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>