<?php
    include_once("utils.php");
    //Resize image proportionaly where you give a max width or max height
    
    // parametros obligatorios
    $parmsob = array("filename","scrw","scrh");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    $ext=substr($_REQUEST["filename"],-3);
    switch ($ext){
            case "png":
                header('Content-type: image/png');
                break;
            case "jpg":
                header('Content-type: image/jpeg');
                break;
            default:
                badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
    }
    
    //$myimage = resizeImage('filename', 'newwidthmax', 'newheightmax');
    $myimage=resizeImage($_REQUEST["filename"], $_REQUEST["scrw"], $_REQUEST["scrh"]);
    print $myimage;
    
    function resizeImage($filename, $newwidth, $newheight){
        $ext=substr($filename,-3);
        list($width, $height) = getimagesize($filename);
        if($width > $height && $newheight < $height){
            $newheight = $height / ($width / $newwidth);
        } else if ($width < $height && $newwidth < $width) {
            $newwidth = $width / ($height / $newheight);   
        } else {
            $newwidth = $width;
            $newheight = $height;
        }
        $thumb = imagecreatetruecolor($newwidth, $newheight);
        switch ($ext){
            case "png":
                $source = imagecreatefrompng($filename);
                imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                return imagepng($thumb);
            case "jpg":
                $source = imagecreatefromjpeg($filename);
                imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                return imagejpeg($thumb);
            default:
                badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
        }
    }
?>