<?php
// cms/api/events/list

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("order","offset","numofrec","sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    $sql="SELECT id FROM languages";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $arraylanguages = array();
    while ($row = $rs->fetch_assoc()){
        $arraylanguages[]=$row["id"];
    }
    // parametros opcionales
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " AND ";
            $filter .= "(";
            $filter .= "name_esp LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "name_eng LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "name_por LIKE '%" . $filtro[$i] . "%' OR ";                        
            $filter .= "dsc_esp LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "dsc_eng LIKE '%" . $filtro[$i] . "%' OR ";
            $filter .= "dsc_por LIKE '%" . $filtro[$i] . "%' ";
            $filter .= ") ";
        }
    }
    else $filter="";

    // order
    $strorderby="";
    if (isset($_REQUEST["order"])) {
        if ($_REQUEST["order"]>0)
            $type=' ASC ';
        else $type=' DESC ';
        switch (abs($_REQUEST["order"])) {
            case 1:
                $strorderby=" ORDER BY name_esp".$type;
                break;
            case 2:
                $strorderby=" ORDER BY datestart".$type;
                break;
            case 3:
                $strorderby=" ORDER BY dateend".$type;
                break;
            case 4:
                $strorderby=" ORDER BY status".$type;
                break;
            default:
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
        }   
    }    
    
    $sql="SELECT id, name_esp, name_eng, name_por, dsc_esp, dsc_eng, dsc_por, status, activelanguages, ".
        " website, email, facebook, twitter, instagram, linkedin, color1, color2,".
        " DATE_FORMAT(datestart,'%Y-%m-%d') AS datestart, DATE_FORMAT(dateend,'%Y-%m-%d') AS dateend,".
        " DATE_FORMAT(datestart,'%d/%m/%Y') AS datestartformatted, DATE_FORMAT(dateend,'%d/%m/%Y') AS dateendformatted".
        " FROM events ";
    
    $where=false;        
    if (strlen($filter)>0) {
        $sql= $sql." WHERE ".$filter." ";
        $where = true;
    }

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
    
    // Se concatena el order by 
    $sql= $sql.$strorderby;
    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrec"];
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $events = array();
    $languages = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=new stdClass;
        $record->name->esp=nvl($row["name_esp"],"");
        $record->name->eng=nvl($row["name_eng"],"");
        $record->name->por=nvl($row["name_por"],"");
        $record->languages = new stdClass;
        $languages = null;
        // Se llenan todos los lenguajes
        foreach ($arraylanguages as $value) {
            $language = new stdClass;
            $language->id=$value;
            if ($value == "esp")
                $language->name="Español";
            else if ($value == "eng")
                $language->name="English";
                else if ($value == "por")
                    $language->name="Portugues";
            $language->active=false;
            $languages[]=$language;
        }
        // Se marcan los lenguajes activos del evento
        $activelanguages=explode(",", $row["activelanguages"]);
        // Recorre todos los lenguajes posibles
        foreach ($languages as $value) {
            // Compara con cada lenguaje del evento 
           foreach ($activelanguages as $activado) {
                // Si son iguales lo activa
                if ($value->id == $activado) {
                    $value->active=true;
                }
            } 
        }
        
        $record->languages = $languages;
        $record->status=new stdClass;
        if ($row["status"]==1){
            $record->status->id = 1;
            $record->status->dsc = "Activo";
        }
        else{
            $record->status->id = 0;
            $record->status->dsc = "Inactivo";
        }
        $record->datestart=new stdClass;
        $record->datestart->date=$row["datestart"];
        $record->datestart->formatted=$row["datestartformatted"];
        $record->dateend=new stdClass;
        $record->dateend->date=$row["dateend"];
        $record->dateend->formatted=$row["dateendformatted"];
        $record->dsc=new stdClass;
        $record->dsc->esp=nvl($row["dsc_esp"],"");
        $record->dsc->eng=nvl($row["dsc_eng"],"");
        $record->dsc->por=nvl($row["dsc_por"],"");
        $record->website=nvl($row["website"],"");
        $record->email=nvl($row["email"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
        $record->colors=new stdClass;
        $record->colors->first=nvl($row["color1"],"");
        $record->colors->second=nvl($row["color2"],"");
        
        $events[] = $record;
    }
    
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$events;
    $out->security=new stdClass;
    $out->security->insert=true;
    $out->security->update=true;
    $out->security->delete=true;
    $out->security->read=true;
    
    //$out->sql =$sql;
    
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>