<?php
// cms/api/events/entry

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("id");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    if ($_REQUEST["sessionid"])
        $userid = isSessionValidCMS($db, $_REQUEST["sessionid"]);
    
    $sql="SELECT id FROM languages";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $arraylanguages = array();
    while ($row = $rs->fetch_assoc()){
        $arraylanguages[]=$row["id"];
    }
    $sql="SELECT utc_zoneid, city, id, name_esp, name_eng, name_por, dsc_esp, dsc_eng, dsc_por, status, activelanguages, defaultlang, ".
        " website, email, facebook, twitter, instagram, linkedin, color1, color2,".
        " DATE_FORMAT(datestart,'%Y-%m-%d') AS datestart, DATE_FORMAT(dateend,'%Y-%m-%d') AS dateend,".
        " DATE_FORMAT(datestart,'%d/%m/%Y') AS datestartformatted, DATE_FORMAT(dateend,'%d/%m/%Y') AS dateendformatted".
        " FROM events WHERE id=".$_REQUEST["id"];
    
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $languages = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=new stdClass;
        $record->name->esp=nvl($row["name_esp"],"");
        $record->name->eng=nvl($row["name_eng"],"");
        $record->name->por=nvl($row["name_por"],"");
        $record->languages = new stdClass;
        $languages = null;
        // Se llenan todos los lenguajes
        foreach ($arraylanguages as $value) {
            $language = new stdClass;
            $language->id=$value;
            switch ($value) {
                case "esp":
                    $language->name="Español";
                    break;
                case "eng":
                    $language->name="English";
                    break;
                case "por":
                    $language->name="Portugues";
                    break;
            }
            $language->active=false;
            $language->default=false;
            $languages[]=$language;
        }
        // Se guardan los lenguajes activos del evento
        $activelanguages=explode(",", $row["activelanguages"]);
        
        // Recorre todos los lenguajes posibles
        foreach ($languages as $value) {
            // Compara con cada lenguaje activo del evento 
           foreach ($activelanguages as $activado) {
                // Si son iguales lo activa
                if ($value->id == $activado) {
                    $value->active=true;
                }
            } 
            // Compara con el lenguaje por defecto del evento si es igual lo activa
            if ($value->id == $row["defaultlang"]) 
                $value->default=true;
        }
        
        $record->languages = $languages;
        $record->status=new stdClass;
        if ($row["status"]==1){
            $record->status->id = 1;
            $record->status->dsc = "Activo";
        }
        else{
            $record->status->id = 0;
            $record->status->dsc = "Inactivo";
        }
        $record->datestart=new stdClass;
        $record->datestart->date=$row["datestart"];
        $record->datestart->formatted=$row["datestartformatted"];
        $record->dateend=new stdClass;
        $record->dateend->date=$row["dateend"];
        $record->dateend->formatted=$row["dateendformatted"];
        $record->dsc=new stdClass;
        $record->dsc->esp=nvl($row["dsc_esp"],"");
        $record->dsc->eng=nvl($row["dsc_eng"],"");
        $record->dsc->por=nvl($row["dsc_por"],"");
        $record->website=nvl($row["website"],"");
        $record->email=nvl($row["email"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
        $record->colors=new stdClass;
        $record->colors->first=nvl($row["color1"],"");
        $record->colors->second=nvl($row["color2"],"");
        $record->utc_zone=(integer)nvl($row["utc_zoneid"],"");
        $record->city=nvl($row["city"],"");
    }
    $out= new stdClass;
    $out->entry =$record;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>