<?php
// users/insert

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("name","hash","usr");
    if (!parametrosValidos($_REQUEST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $usr = $_REQUEST["usr"];
    $hash = $_REQUEST["hash"];
    $name = $_REQUEST["name"];

    //echo md5($usr.$name);
    if (md5($usr.$name) != $hash){
        badEnd("304", array("msg"=>"Hash inválido"));
    }


    // Seleccionar el primer idioma del evento activo
    $sql="SELECT id, activelanguages FROM events WHERE status=1";
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No hay evento activo disponible"));
    $languages=explode(",",$rowevent["activelanguages"]);
    $favoritelanguage =$languages[0];     
    // Fin seleccionar idioma
    
    $eventid=$rowevent["id"];
    $pwd = "NULL";
    if (isset($_REQUEST["pwd"])){
        $pwd = "'".$_REQUEST["pwd"]."'";
    }
    $tokenid = "NULL";
    if (isset($_REQUEST["tokenid"])){
        $tokenid = "'".$_REQUEST["tokenid"]."'";
        $status = "1";
    }
    $avatar = "NULL";
    if (isset($_REQUEST["avatar"])){
        $avatar = "'".$_REQUEST["avatar"]."'";
    }

    // Validar que el usr no exista INSERT
    $sql="SELECT id FROM appusers WHERE usr='".$usr."'";
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc())
        badEnd("400", array("msg"=>"El usuario ya existe"));

    $sql =  "INSERT INTO appusers " .
    "               (usr, name, pwd, " .
    "                tokenid, avatar, favoritelanguage" .
    "                ) " .
    "        VALUES (" .
    "                '" . $usr . "'," .
    "                '" . $name . "'," .
    "                " . $pwd . "," .
    "                " . $tokenid . "," .
    "                " . $avatar . "," .
    "                '" . $favoritelanguage ."' ".
    "                )";
    
    if (!$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $appuserid=$db->insert_id;
  
    // Asocia al usuario con el evento 
    // Intenta un UPDATE, sino existe, hace el INSERT
    $sql="UPDATE appuserevent SET lastaccess=NOW() WHERE appuserid=$appuserid AND eventid=$eventid";
    if (!$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($db->affected_rows == 0) {
        $sql="INSERT INTO appuserevent (appuserid, eventid, lastaccess) VALUES ($appuserid,$eventid,NOW())";
        if (!$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }

    if (isset($_REQUEST["pushtoken"]) && strlen($_REQUEST["pushtoken"])==0 ){
        // Busca si el usuario está creado en la tabla appuserdevices
        $sql="SELECT appuserid FROM appdeviceuser WHERE appuserid=$appuserid";
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        // Si no existe usuario asociado, busca el token para crear la asociación del usuario con el dispositivo correspondiente al token
        if (!$row = $rs->fetch_assoc()) {
            $sql="SELECT id FROM appdevices WHERE token='".$_REQUEST["pushtoken"]."'";
            if (!$rs=$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            if ($row = $rs->fetch_assoc()) {
                $appdeviceid=$row["id"];
                $sql="INSERT INTO appdeviceuser (appuserid, appdeviceid) VALUES ($appuserid,$appdeviceid) ";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            // El token enviado no tiene dispositivo asociado
            else {
                badEnd("400", array("msg"=>"El token no está asociado a ningún dispositivo"));
            }
        }
    }     
    
    $out= new stdClass;
    
    
    $out->id = $appuserid;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
