<?php
// users/entry

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array(msg=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $id = isSessionValid($db, $_GET["sessionid"]);    
    // Llenar arreglo con todos los idiomas
    $sql="SELECT id FROM languages";
    if (!$rs = $db->query($sql))
        badEnd("500", array(sql=>$sql,msg=>$db->error));
    $languages=array();
    while ($row = $rs->fetch_assoc()){
        $info = new stdClass;
        $info->id=$row["id"];
        switch ($row["id"]) {
            case 'esp':
                $info->name="Español";
                break;
            case 'eng':
                $info->name="English";
                break;
            case 'por':
                $info->name="Português";
                break;
        }
        $info->default=false;
        $languages[]=$info;
    }

    $sql =  "SELECT     id, usr, name, favoritelanguage, receivemessages, avatar, ".
            "           DATE_FORMAT(datecreated,'%Y-%m-%d') dateformatted " .
            "FROM       appusers U " .
            "WHERE      U.id=" . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array(sql=>$sql,msg=>$db->error));
    
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id = (integer) $row["id"];
        $record->usr = $row["usr"];
        $record->name = $row["name"];
        foreach($languages as $language => $grupo)
            foreach ($grupo as $clave =>$valor) 
                if ($clave=="id" && $valor==$row["favoritelanguage"])
                    $grupo->default=true;
        $record->language=$languages;
        $record->avatar = nvl($row["avatar"],"");
        if ($row["receivemessages"]==1)
            $record->receivemessages = true;
        else
            $record->receivemessages = false;
        $record->datecreated = $row["dateformatted"];
    }
    
    $out=new stdClass;
    $out->entry=$record;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    /*....
            "name": "Nombre de Usuario UNO",
            "language": [
                {
                    "id": 1,
                    "name": "Español",
                    "default": true
                },
                ...
            ],
            "avatar": "",
    */



?>
