<?php
// app/api/surveys/list.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");

    // parametros obligatorios
    $parmsob = array("surveyids");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $surveyids=str_replace("-",",",$_REQUEST["surveyids"]);
    
    //Seleccionar idioma por defecto del evento y los idiomas disponibles 
    $sql="SELECT E.id, activelanguages, defaultlang ".
        "FROM events E ".
        "INNER JOIN surveys S ON S.eventid=E.id ".
        "WHERE E.status=1 ".
        "AND S.id IN (".$surveyids.")";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()){
        $language=explode(",",$row["activelanguages"]);
        $eventid=$row["id"];
        $defaultlang=$row["defaultlang"];
    }
    else
        badEnd("400", array("msg"=>"Las encuestas no pertenecen al evento activo"));
    //Si el usuario es logueado buscar el idioma favorito
    $favoritelang="";
    if (isset($_REQUEST["sessionid"])){
        $userid=isSessionValid($db,$_REQUEST["sessionid"]);
        $sql="SELECT favoritelanguage ".
            " FROM appusers WHERE id=".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc()) 
            $favoritelang=$row["favoritelanguage"];
        // Buscar si el idioma favorito est¨¢ entre los idiomas disponibles del evento
        //sino est¨¢, se deja el idioma por defecto del evento
        $foundmylanguage=false;
        foreach ($language as $valor) 
            if ($valor==$favoritelang) {
                $foundmylanguage=true;                    
                break;
            }
        if ($foundmylanguage) 
            $defaultlang=$favoritelang;            
    }
    
    $outputlanguage = $defaultlang;
    
    // Se marca la visita en visitlog
    $contenttype=4; //CONTENTTYPE 1=actividad, 2=panelista, 3=lugar, 4=encuesta, 5=Patrocinantes
    $refid=0; // REFID 0 cuando es acceso al listado
    if (isset($_REQUEST["sessionid"])){
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);    
        $sql="INSERT INTO visitlog (id, contenttype, refid, appuserid, eventid) VALUES ("
        . " 0, $contenttype, $refid, $appuserid, $eventid )";
        if (!$db->query($sql))
    	    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    else {
        $sql="INSERT INTO visitlog (id, contenttype, refid, eventid) VALUES ("
        . " 0, $contenttype, $refid, $eventid )";
        if (!$db->query($sql))
    	    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }    
    
    // Llenar arreglo con la cantidad de preguntas de cada encuesta
    $sql="SELECT SQ.surveyid, count(*) AS Cnt FROM surveyquestions SQ ".
        " WHERE SQ.surveyid IN (".$surveyids.") ".
        " GROUP BY SQ.surveyid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $qtytotal = array();
    while ($row = $rs->fetch_assoc())
        $qtytotal[$row["surveyid"]]=$row["Cnt"];

    if (!isset($_REQUEST["sessionid"]))
        $sql="SELECT S.id AS surveyid, ".
        "S.name_esp,S.name_eng,S.name_por, ".
        "S.dsc_esp AS surveydsc_esp, S.dsc_eng AS surveydsc_eng, S.dsc_por AS surveydsc_por, ".
        "S.status AS surveystatus, ".
        "Q.qty, Q.responses, Q.closed ".
        " FROM surveys S ".
            " INNER JOIN ".
                " (SELECT SQ.surveyid, COUNT(*) AS qty, COUNT(appuserid) AS responses, SR.closed ".
                " FROM surveyquestions SQ ".
                " LEFT JOIN surveyresponses SR ON SQ.id = SR.surveyquestionid ".
                " WHERE SQ.surveyid IN (".$surveyids.") ".
                " GROUP BY SQ.surveyid) Q ".
            " ON Q.surveyid=S.id ".
        "WHERE S.id IN (".$surveyids.")";
    else
        $sql="SELECT S.id AS surveyid, ".
            "S.name_esp,S.name_eng,S.name_por, ".
            "S.dsc_esp AS surveydsc_esp, S.dsc_eng AS surveydsc_eng, S.dsc_por AS surveydsc_por, ".
            "S.status AS surveystatus, ".
            "Q.qty, Q.responses, Q.closed ".
            " FROM surveys S ".
                " LEFT JOIN ".
                    " (SELECT SQ.surveyid, COUNT(*) AS qty, COUNT(appuserid) AS responses, SR.closed ".
                    " FROM surveyquestions SQ ".
                    " LEFT JOIN surveyresponses SR ON SQ.id = SR.surveyquestionid ".
                    " WHERE SQ.surveyid IN (".$surveyids.") AND SR.appuserid=".$userid. " ".
                    " GROUP BY SQ.surveyid) Q ".
                " ON Q.surveyid=S.id ".
            "WHERE S.id IN (".$surveyids.")";
        

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }
   
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $surveys = array();
    $surveyact="";
    while ($row = $rs->fetch_assoc()){
            $survey=new stdClass;
            $survey->id=(integer)$row["surveyid"];
            if (!is_null($row["name_".$outputlanguage]) && trim($row["name_".$outputlanguage])!="")
                $survey->name=$row["name_".$outputlanguage];
            elseif (!is_null($row["name_esp"]) && trim($row["name_esp"])!="")
                $survey->name=$row["name_esp"];
            elseif (!is_null($row["name_eng"]) && trim($row["name_eng"])!="")
                $survey->name=$row["name_eng"];
            elseif (!is_null($row["name_por"]) && trim($row["name_por"])!="")
                $survey->name=$row["name_por"];
            else
                $survey->name="";

            if (!is_null($row["surveydsc_".$outputlanguage]) && trim($row["surveydsc_".$outputlanguage])!="")
                $survey->dsc=$row["surveydsc_".$outputlanguage];
            elseif (!is_null($row["surveydsc_esp"]) && trim($row["surveydsc_esp"])!="")
                $survey->dsc=$row["surveydsc_esp"];
            elseif (!is_null($row["surveydsc_eng"]) && trim($row["surveydsc_eng"])!="")
                $survey->dsc=$row["surveydsc_eng"];
            elseif (!is_null($row["surveydsc_por"]) && trim($row["surveydsc_por"])!="")
                $survey->dsc=$row["surveydsc_por"];
            else
                $survey->dsc="";                
            $survey->status= new stdClass;
            if ($row["surveystatus"]==1) {
                $survey->status->id=1;
                $survey->status->dsc="Activo";
            }
            else {
                $survey->status->id=0;
                $survey->status->dsc="Inactivo";
            }
            $survey->questions= new stdClass;
            $survey->questions->qty= (integer)$qtytotal[$row["surveyid"]];
            if (isset($_REQUEST["sessionid"])) {
                $survey->questions->responses= (integer)$row["responses"];
                if ($row["closed"]==1) 
                    $survey->questions->closed=true;
                else
                    $survey->questions->closed=false;
            }
            else { 
                $survey->questions->responses=0;
                $survey->questions->closed=0;                
            }

            $surveys[]=$survey;
    }
  
    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$surveys;
    //$out->sql=$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();

?>