<?php
// app/api/sites/list.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("offset","numofrecords");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Seleccionar el evento activo y los idiomas disponibles
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE status=1";
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No hay evento activo disponible"));
    $eventid=$rowevent["id"];
    $languages=explode(",",$rowevent["activelanguages"]);

    $onlogin=0;
    $outputlanguage = $rowevent["defaultlang"];
    // Caso donde el usuario es logueado
    if (isset($_REQUEST["sessionid"])){
        //Obtener el id del usuario logueado
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);
        $onlogincondition="";
        // Seleccionar el idioma favorito del usuario logueado
        $sql="SELECT favoritelanguage FROM appusers WHERE id=".$appuserid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $row = $rs->fetch_assoc();
        $favoritelanguage=$row["favoritelanguage"];
        // Revisar si el idioma favorito esta dentro de los disponibles, si no esta devolver el idioma por defecto del evento
        foreach ($languages as $value){
            if ($value==$favoritelanguage)
                $outputlanguage=$value;
        }
    }
    else
       $onlogincondition=" AND onlogin=0 " ;

    // Se marca la visita en visitlog
    $contenttype=3; //CONTENTTYPE 1=actividad, 2=panelista, 3=lugar, 4=encuesta, 5=Patrocinantes
    $refid=0; // REFID 0 cuando es acceso al listado
    if (isset($_REQUEST["sessionid"])){
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);    
        $sql="INSERT INTO visitlog (id, contenttype, refid, appuserid, eventid) VALUES ("
        . " 0, $contenttype, $refid, $appuserid, $eventid )";
        if (!$db->query($sql))
    	    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    else {
        $sql="INSERT INTO visitlog (id, contenttype, refid, eventid) VALUES ("
        . " 0, $contenttype, $refid, $eventid )";
        if (!$db->query($sql))
    	    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }

    
    //Se establece un filtro por el nombre o las coordenadas
    if (isset($_REQUEST["filter"])){
        $filtro = explode("+",$_REQUEST["filter"]);
        for ($i=0; $i<sizeof($filtro); $i++){
            if ($i>0) $filter .= " OR ";
            $filter .= "(";
            $filter .= " name_esp LIKE '%" . $filtro[$i] . "%'";
            $filter .= " OR name_eng LIKE '%" . $filtro[$i] . "%'";
            $filter .= " OR name_por LIKE '%" . $filtro[$i] . "%'";                        
            $filter .= " OR coords LIKE '%" . $filtro[$i] . "%'";
            $filter .= ") ";
        }
    }
    else $filter="";

    //tags
    if (isset($_REQUEST["tags"])){
        $tags = explode("-",$_REQUEST["tags"]);
        for ($i=0; $i<sizeof($tags); $i++){
            if ($i>0) $filtertag .= " OR ";
            $filtertag .= "(";
            $filtertag .= " tags LIKE '%" . $tags[$i] . "%'  ";
            $filtertag .= ") ";
        }
    }
    else $filtertag="";

    // activityid NO DEFINIDO
    //if (isset($_REQUEST["activityid"]))

    // order
    $strorderby=" ORDER BY name_esp ASC";
    if (isset($_REQUEST["order"])) {
        if ($_REQUEST["order"]>0)
            $type=' ASC ';
        else $type=' DESC ';
        switch (abs($_REQUEST["order"])) {
            case 1:
                $strorderby=" ORDER BY name_".$outputlanguage." ".$type;
                break;
            default:
                badEnd("400", array('msg'=>"El valor del campo orden esta fuera del rango de opciones permitido"));
        }   
    }    

    // query principal
    $sql="SELECT id, name_esp, name_eng, name_por, tags, dsc_esp, dsc_eng, dsc_por, coords ".
        " FROM sites ".
        " WHERE sites.eventid=".$eventid;

    // Si hay filtro lo incluyo    
    if (strlen($filter)>0) 
        $sql= $sql." AND ".$filter." ";
    
    // Si hay filtro de tag lo incluyo    
    if (strlen($filtertag)>0) 
        $sql= $sql." AND (".$filtertag.") ";

    $sqlCnt =  "SELECT COUNT(*) cnt FROM (" . $sql  .") B";
    if (!$rsCnt=$db->query($sqlCnt)){
        badEnd("500", array("sql"=>$sqlCnt,"msg"=>$db->error));
    }else{
        $cnt = $rsCnt->fetch_assoc();
        $numofrecords = $cnt['cnt'];
    }

    // Se concatena el order by 
    $sql= $sql.$strorderby;

    // Se limita numero de registros segun parametros opcionales offset y numrecordstoshow
    $sql =  "SELECT A.* FROM (" . $sql . ") A " .
            "LIMIT " . $_REQUEST["offset"] . "," . $_REQUEST["numofrecords"];
    
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        
    //** Se llena arreglo de actividades
    $sqlact="SELECT   S.id siteid,    S.name_".$outputlanguage." AS sitename,    A.id activityid, ".
    " A.name_esp,    A.name_eng,    A.name_por, ".
    " DATE_FORMAT(datefrom,'%d/%m/%Y') AS dateformattedfrom, ".
    " DATE_FORMAT(dateto,'%d/%m/%Y') AS dateformattedto, ".
    " DATE_FORMAT(datefrom,'%h:%i %p') AS start, ".            
    " DATE_FORMAT(dateto,'%h:%i %p') AS end, ".
    " DATE_FORMAT(A.datefrom, '%d/%m/%Y') AS datefrom1, ".
    " DATE_FORMAT(A.datefrom, '%h:%i %p') AS datefrom2, ".
    " DATE_FORMAT(A.dateto, '%d/%m/%Y') AS dateto1, ".
    " DATE_FORMAT(A.dateto, '%h:%i %p') AS dateto2,  A.tags ".
    " FROM    activities A INNER JOIN sites S ON     S.id = A.siteid WHERE A.eventid=".$eventid.
    " ORDER BY    S.id,    A.id";
       
    if (!$rsact=$db->query($sqlact))
        badEnd("500", array("sql"=>$sqlact,"msg"=>$db->error));
    $indice = array();
    $activities = array();
    $siteid=0;
    while ($rowact = $rsact->fetch_assoc()){
        if ($siteid==0)
            $siteid=$rowact["siteid"];
        if ($siteid<>$rowact["siteid"]) {
            $indice[$siteid] = $activities;
            $siteid=$rowact["siteid"];
            unset($activities);
        }
        $estructura = new stdClass;
        $estructura->id=(integer)$rowact["activityid"];
        switch ($outputlanguage) {
            case "esp":
                $name=nvl($rowact["name_esp"],"");
                break;
            case "eng":
                $name=nvl($rowact["name_eng"],"");
                break;
            case "por":
                $name=nvl($rowact["name_por"],"");
                break;
            default:
                $name="";
        }

        if (strlen($name)==0)
            $name=$rowact["name_esp"];
            
        $estructura->name=$name;
        $estructura->from = new stdClass;
        $estructura->from->date=$rowact["dateformattedfrom"];
        $estructura->from->formatted=$rowact["datefrom2"];
        $estructura->from->timefrom=$rowact["start"];        
        $estructura->to = new stdClass;
        $estructura->to->date=$rowact["dateformattedto"];
        $estructura->to->formatted=$rowact["dateto2"];
        $estructura->to->timeto=$rowact["end"];        
        $estructura->tags=$rowact["tags"];

        $activities[]=$estructura;
    }
    //**
        
        
        
    $records = array();
    while ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        switch ($outputlanguage){
            case "esp":
                $dsc = nvl($row["dsc_esp"],"");
                $namesite=nvl($row["name_esp"],"");
                break;
            case "eng":
                $dsc = nvl($row["dsc_eng"],"");
                $namesite=nvl($row["name_eng"],"");
                break;
            case "por":
                $dsc = nvl($row["dsc_por"],"");
                $namesite=nvl($row["name_por"],"");
                break;
            default:
                $dsc = "";
                $namesite="";
                break;                
        }         
        $record->name=$namesite;
        $record->coords=nvl($row["coords"],"");
        $record->tags=nvl($row["tags"],"");            
        $record->dsc=$dsc;
        $record->activities=$indice[$row["id"]];

        $records[] = $record;
    }

    $out= new stdClass;
    $out->numofrecords=(integer)$numofrecords;
    $out->records =$records;
    $out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>