<?php
// api/home/entry
    
    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("screenwidth","screenheight","platform");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    // Seleccionar el evento activo y los idiomas disponibles
    

    
    $sql="SELECT city,facebook,twitter,instagram, linkedin, id, activelanguages, defaultlang, color1, color2 FROM events WHERE status=1";
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No hay evento activo disponible"));
    $eventid=$rowevent["id"];
    $languages=explode(",",$rowevent["activelanguages"]);

    //$onlogin=0;
    $outputlanguage = $rowevent["defaultlang"]; 
    
    $token=false;
    if ($_REQUEST["platform"] == 1 || $_REQUEST["platform"] == 2) {
        if (!isset($_REQUEST["pushtoken"]))
            badEnd("400", array("msg"=>"Debe indicar el token"));
        $token = $_REQUEST["pushtoken"];
        // Si el token no existe lo inserto, sino no hago nada
        $sql="SELECT token FROM appdevices WHERE token='$token'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if(!$row = $rs->fetch_assoc()) {
            $sql= "INSERT INTO appdevices (token, platform) VALUES ('".$token."',".$_REQUEST["platform"].")";
            if (!$db->query($sql)) 
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            $id =$db->insert_id; 
        }
    }

    // Caso donde el usuario es logueado
    if (isset($_REQUEST["sessionid"])){
        //Obtener el id del usuario logueado
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);
        $onlogincondition="";
        // Seleccionar el idioma favorito del usuario logueado
        $sql="SELECT favoritelanguage FROM appusers WHERE id=".$appuserid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $row = $rs->fetch_assoc();
        $favoritelanguage=$row["favoritelanguage"];
        // Revisar si el idioma favorito esta dentro de los disponibles, si no esta devolver el idioma por defecto del evento
        foreach ($languages as $value){
            if ($value==$favoritelanguage)
                $outputlanguage=$value;
        }
    }
    else
       $onlogincondition=" AND onlogin=0 " ;
    // Informacion de los botones
    $sql="SELECT B.id buttonid, B.contentid, C.dsc contentdsc, width,".
    " title_esp, title_eng, title_por, dsc_esp, dsc_eng, dsc_por, imgtype, ".
    " opt1, opt2, opt3, opt4, opt5, opt6, opt7, opt8, opt9, opt10 ".
    " FROM buttons B INNER JOIN contents C ON C.id=B.contentid".
    " WHERE B.eventid=".$eventid .$onlogincondition." AND status=1 ORDER by `order`";
    
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $buttons = array();
    $options = array();
    while ($row = $rs->fetch_assoc()){
        $boton=new stdClass;
        $boton->content = new stdClass;
        $boton->content->id = $row["contentid"];
        $boton->content->dsc = $row["contentdsc"];
        switch ($outputlanguage){
            case "esp":
                $boton->title = $row["title_esp"];
                $boton->dsc = $row["dsc_esp"];
                break;
            case "eng":
                $boton->title = $row["title_eng"];
                $boton->dsc = $row["dsc_eng"];
                break;
            case "por":
                $boton->title = $row["title_por"];
                $boton->dsc = $row["dsc_por"];
                break;
            default:
                $boton->title = "";
                $boton->dsc = "";
                break;                
        }   
        // url de la imagen
        if (!is_null($row["imgtype"])) {
            switch ($row["imgtype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array("id"=>1,"msg"=>"El formato del documento debe ser PNG o JPG"));
            }

             $boton->url="./api/getimage.php?filename="."../uploads/buttons/".$row["buttonid"].$ext."&scrw=".$_REQUEST["screenwidth"]."&scrh=".$_REQUEST["screenheight"];
            //$boton->url="./uploads/buttons/".$row["buttonid"].$ext;
        }
        else
            $boton->url="";
        // Fin imagen
        $boton->width=nvl($row["width"],"");
        $opciones=  $row["opt1"].",".$row["opt2"].",".$row["opt3"].",".$row["opt4"].",".$row["opt5"].",".
                    $row["opt6"].",".$row["opt7"].",".$row["opt8"].",".$row["opt9"].",".$row["opt10"];
        $options=explode(",",$opciones);                    
        $boton->options=$options;
        $buttons[]=$boton;
    }


    
    $out=new stdClass;
    $out->device=new stdClass;
    $out->device->pushtoken=$token;
    $out->event=new stdClass;
    $out->event->id=(integer)$eventid;
    $out->event->colors = new stdClass;
    $out->event->colors->first=$rowevent["color1"];
    $out->event->colors->second=$rowevent["color2"];

    $out->event->facebook=$rowevent["facebook"];
    $out->event->twitter=$rowevent["twitter"];
    $out->event->instagram=$rowevent["instagram"];
    $out->event->linkedin=$rowevent["linkedin"];
    $out->event->language=$outputlanguage;
    $out->event->city=$rowevent["city"];
    $out->event->buttons=$buttons;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
?>