<?php
// api/events/entry
    
    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("eventid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array(msg=>"Parametros obligatorios " . implode(", ", $parmsob)));
    

    //Si el usuario es logueado buscar el idioma favorito
    $favoritelang="";
    if (isset($_REQUEST["sessionid"])){
        $userid=isSessionValid($db,$_REQUEST["sessionid"]);
        $sql="SELECT favoritelanguage ".
            " FROM appusers WHERE id=".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        if ($row = $rs->fetch_assoc()) 
            $favoritelang=$row["favoritelanguage"];
    }    
    
    // Query principal
    $sql="SELECT id, activelanguages, defaultlang, name_esp, name_eng, name_por, dsc_esp, dsc_eng, dsc_por, ".
        " website, email, facebook, twitter, instagram, linkedin,color1, color2 ".
        " FROM events WHERE id=".$_REQUEST["eventid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($row = $rs->fetch_assoc()) {
        $language=explode(",",$row["activelanguages"]);
        
        // Si est logueado buscar si el idioma favorito est entre los idiomas disponibles del evento
        //sino est, se deja el idioma por defecto del evento
        $foundmylanguage=false;
        if (isset($_REQUEST["sessionid"])) 
            foreach ($language as $valor) 
                if ($valor==$favoritelang) {
                    $foundmylanguage=true;                    
                    break;
                }

        //Fin
        if (strlen(trim($favoritelang))==0 || !$foundmylanguage) 
            $favoritelang=$row["defaultlang"];

        switch ($favoritelang) {
            case 'esp':
                $name=$row["name_esp"];
                $dsc=$row["dsc_esp"];
                break;
            case 'eng':
                $name=$row["name_eng"];
                $dsc=$row["dsc_eng"];
                break;
            case 'por':
                $name=$row["name_por"];
                $dsc=$row["dsc_por"];
                break;
        }
        $out=new stdClass;
        $out->entry=new stdClass;
        $out->entry->id=(integer)$row["id"];
        $out->entry->language=$favoritelang;
        $out->entry->name=$name;        
        $out->entry->dsc=$dsc;        
        $out->entry->website=$row["website"];
        $out->entry->email=$row["email"];        
        $out->entry->facebook=$row["facebook"];        
        $out->entry->twitter=$row["twitter"];                
        $out->entry->instagram=$row["instagram"];
        $out->entry->linkedin=$row["linkedin"];        
        $out->entry->colors=new stdClass;
        $out->entry->colors->first=$row["color1"];        
        $out->entry->colors->second=$row["color2"];
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>