<?php
// app/api/panelists/entry.php

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    
    // parametros obligatorios
    $parmsob = array("panelistid","screenwidth","screenheight");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
        
    // Seleccionar el evento activo y los idiomas disponibles
    $sql="SELECT id, activelanguages, defaultlang FROM events WHERE status=1";
    if (!$rsevent=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$rowevent = $rsevent->fetch_assoc())
        badEnd("400", array("msg"=>"No hay evento activo disponible"));
    $eventid=$rowevent["id"];
    $languages=explode(",",$rowevent["activelanguages"]);

    $onlogin=0;
    $outputlanguage = $rowevent["defaultlang"];
    // Caso donde el usuario es logueado
    if (isset($_REQUEST["sessionid"])){
        //Obtener el id del usuario logueado
        $appuserid=isSessionValid($db,$_REQUEST["sessionid"]);
        $onlogincondition="";
        // Seleccionar el idioma favorito del usuario logueado
        $sql="SELECT favoritelanguage FROM appusers WHERE id=".$appuserid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        $row = $rs->fetch_assoc();
        $favoritelanguage=$row["favoritelanguage"];
        // Revisar si el idioma favorito esta dentro de los disponibles, si no esta devolver el primer idioma del evento
        foreach ($languages as $value){
            if ($value==$favoritelanguage)
                $outputlanguage=$value;
        }
    }
    else
       $onlogincondition=" AND onlogin=0 " ;        
    
    // activityid NO DEFINIDO
    //if (isset($_REQUEST["activityid"]))


    $sql="SELECT id, name, surname, CONCAT_WS(' ',name,surname) fullname, ".
        " imagetype, tags, company, position_esp, dsc_esp, ".
        " position_eng, dsc_eng, position_por, dsc_por, ".
        " email, website, facebook, twitter, instagram, linkedin " .
        " FROM panelists ".
        " WHERE eventid=".$eventid." AND id=".$_REQUEST["panelistid"];
    
    // Se ejecuta el query principal
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    //** Se llena arreglo de actividades
    $sqlact="SELECT S.id AS siteid, S.name_".$outputlanguage." AS sitename, P.id panelistid, P.name panelistname, A.id activityid, A.name_".$outputlanguage." AS name, A.name_esp, A.name_eng, A.name_por, ".
            " DATE_FORMAT(A.datefrom,'%Y-%m-%d %H:%i') AS datefrom1, DATE_FORMAT(A.datefrom,'%Y-%m-%d %h:%i%p') AS datefrom2, ".
            " DATE_FORMAT(datefrom,'%d/%m/%Y') AS dateformattedfrom, ".
            " DATE_FORMAT(dateto,'%d/%m/%Y') AS dateformattedto, ".
            " DATE_FORMAT(datefrom,'%h:%i %p') AS start, ".            
            " DATE_FORMAT(dateto,'%h:%i %p') AS end, ".
            " DATE_FORMAT(A.dateto,'%Y-%m-%d %H:%i') AS dateto1, DATE_FORMAT(A.dateto,'%Y-%m-%d %h:%i%p') AS dateto2, A.tags ".            
            " FROM activitypanelists AP INNER JOIN panelists P ON  P.id = AP.panelistid ".
            " INNER JOIN activities A ON    A.id = AP.activityid ".
            " INNER JOIN sites S ON S.id=A.siteid ".
            " WHERE P.id=".$_REQUEST["panelistid"]." ORDER BY P.id, A.id ";
       
    if (!$rsact=$db->query($sqlact))
        badEnd("500", array("sql"=>$sqlact,"msg"=>$db->error));

    $activities = array();
    $panelistid=0;
    while ($rowact = $rsact->fetch_assoc()){
        if ($panelistid==0)
            $panelistid=$rowact["panelistid"];
        $estructura = new stdClass;
        $estructura->id=(integer)$rowact["activityid"];
        switch ($outputlanguage) {
            case "esp":
                $name=nvl($rowact["name_esp"],"");
                break;
            case "eng":
                $name=nvl($rowact["name_eng"],"");
                break;
            case "por":
                $name=nvl($rowact["name_por"],"");
                break;
            default:
                $name="";
        }

        if (strlen($name)==0)
            $name=$rowact["name"];
            
        $estructura->name=$rowact["name"];
        $estructura->from = new stdClass;
        $estructura->from->date=$rowact["dateformattedfrom"];
        $estructura->from->formatted=$rowact["datefrom2"];
        $estructura->from->timefrom=$rowact["start"];
        $estructura->to = new stdClass;
        $estructura->to->date=$rowact["dateformattedto"];
        $estructura->to->formatted=$rowact["dateto2"];
        $estructura->to->timeto=$rowact["end"];
        $estructura->tags=$rowact["tags"];
        $estructura->site=new stdClass;
        $estructura->site->id=$rowact["siteid"];
        $estructura->site->name=$rowact["sitename"];

        $activities[]=$estructura;
    }
    //**

    
    if ($row = $rs->fetch_assoc()){
        $record = new stdClass;
        $record->id=(integer)$row["id"];
        $record->name=nvl($row["name"],"");
        $record->surname=nvl($row["surname"],"");
        $record->fullname=nvl($row["fullname"],"");
        // Imagen
        if (!is_null($row["imagetype"])) {
            switch ($row["imagetype"]){
                case "image/png":
                    $ext = ".png";
                    break;
                case "image/jpeg":
                case "image/jpg":
                    $ext = ".jpg";
                    break;
                default:
                    badEnd("500", array(id=>1,msg=>"El formato del documento debe ser PNG o JPG"));
            }
            //$homeurl = "http://totalsoftware.la/~clad/dev/app/";
            $url=$homeurl."../cms";
            $record->image= $url."/api/getimage.php?filename=../uploads/panelists/".$row["id"].$ext."&scrw=".$_REQUEST["screenwidth"]."&scrh=".$_REQUEST["screenheight"];                                
        }
        else
            $record->image="";
        // Fin imagen        
        $record->tags=nvl($row["tags"],"");            
        $record->company=nvl($row["company"],"");
        switch ($outputlanguage){
            case "esp":
                $pos = nvl($row["position_esp"],"");
                $dsc = nvl($row["dsc_esp"],"");
                break;
            case "eng":
                $pos = nvl($row["position_eng"],"");
                $dsc = nvl($row["dsc_eng"],"");
                break;
            case "por":
                $pos = nvl($row["position_por"],"");
                $dsc = nvl($row["dsc_por"],"");
                break;
            default:
                $pos = "";
                $dsc = "";
                break;                
        }        
        $record->position=$pos;
        $record->dsc=$dsc;
        $record->email=nvl($row["email"],"");
        $record->website=nvl($row["website"],"");
        $record->facebook=nvl($row["facebook"],"");
        $record->twitter=nvl($row["twitter"],"");
        $record->instagram=nvl($row["instagram"],"");
        $record->linkedin=nvl($row["linkedin"],"");
        $record->activities=$activities;
    }
    $out = new stdClass;
    $out->entry =$record;
    //$out->sql =$sql;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>