<?php
// app/api/login/login.php

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("usr");
    if (!parametrosValidos($_REQUEST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $usr = strtoupper($_REQUEST["usr"]);
    
    $pwd = "";
    if (isset($_REQUEST["pwd"])){
        $pwd = $_REQUEST["pwd"];
    }
    $tokenid = "";
    if (isset($_REQUEST["tokenid"])){
        $tokenid = $_REQUEST["tokenid"];
    }
    
    $sessid = randomString(32);
    
    // tratamiento con password
    if ($tokenid == ""){
        // destruir cualquier session anterior existente
        $sql =  "UPDATE appusers " .
                "SET    sessionid = '" . $sessid . "', ".
                "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY) ".
                "WHERE  UPPER(usr)='".$usr."' ".
                "AND    pwd='".$pwd."' " .
                "AND    status<>0";

        if (!$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        
        
        if ($db->affected_rows == 0)
            badEnd("401", array("msg"=>"Usuario/Clave Inválidos o Usuario Inactivo" ));
        
        
        $sql =  "SELECT  id, sessionid,  DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt, name ".
                "FROM    appusers ".
                "WHERE   UPPER(usr)='".$usr."' ".
                "AND     pwd='".$pwd."'";
    }else{
        // tratamiento con tokenid
        // validar si existe el usuario ya registrado pero no con google
        $sql =  "SELECT id " . 
                "FROM   appusers " .
                "WHERE  UPPER(usr) = '" . $usr . "'";
        if (!$rs = $db->query($sql)){
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }
        if ($row = $rs->fetch_assoc()){
            if ($row["id"]!=NULL){
                $sql =  "UPDATE appusers " .
                        "SET    tokenid = '" . $tokenid . "' ".
                        "WHERE  id='".$row["id"]."'";
                if (!$db->query($sql)){
                    badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
                }
            }
        }
        
        // destruir cualquier session anterior existente
        $sql =  "UPDATE appusers " .
                "SET    sessionid = '" . $sessid . "', ".
                "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY) ".
                "WHERE  UPPER(usr)='".$usr."' ".
                "AND    tokenid='".$tokenid."' " .
                "AND    status<>0";
        if (!$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        
     
        if ($db->affected_rows == 0)
            badEnd("401", array("msg"=>"Usuario/Token Inválidos o Usuario Inactivo"));
        
        $sql =  "SELECT  id, sessionid, DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt, name ".  
                "FROM    appusers ".
                "WHERE   UPPER(usr)='".$usr."' ".
                "AND     tokenid='".$tokenid."'";
    }
    
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    $row = $rs->fetch_assoc();
    $appuserid=$row["id"];
    $sessionid=$row["sessionid"];
    $vt=$row["vt"];
    $name=$row["name"];
    
    //Buscar el evento activo
    $sql="SELECT id FROM events WHERE status=1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if (!$row = $rs->fetch_assoc())
        badEnd("400", array("msg"=>"No hay evento activo disponible"));
    $eventid = $row["id"];     
    // Fin buscar el evento activo    
    

    // Asocia al usuario con el evento 
    // Intenta un UPDATE, sino existe, hace el INSERT
    $sql="UPDATE appuserevent SET lastaccess=NOW() WHERE appuserid=$appuserid AND eventid=$eventid";
    if (!$db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    if ($db->affected_rows == 0) {
        $sql="INSERT INTO appuserevent (appuserid, eventid, lastaccess) VALUES ($appuserid,$eventid,NOW())";
        if (!$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }


    // Si se envía el pushtoken se inserta en appdeviceuser
    if (isset($_REQUEST["pushtoken"])){
    
        $sql = "SELECT U.appdeviceid  "
        . "FROM appdeviceuser U  "
        . "INNER JOIN appdevices D ON D.id=U.appdeviceid "
        . "WHERE U.appuserid= $appuserid  "
        . "AND D.token = '".$_REQUEST["pushtoken"]."'";

        if (!$rs=$db->query($sql))
            badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        // Si no existe lo inserta
        if (!$row = $rs->fetch_assoc())   {
            // Busca el deviceid con el pushtoken
            $sql="SELECT id FROM appdevices WHERE token='".$_REQUEST["pushtoken"]."'";
            if (!$rs=$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            if (!$row = $rs->fetch_assoc()) 
                badEnd("400", array("msg"=>"No se encontró el token"));
            $appdeviceid=$row["id"];

            $sql="INSERT INTO appdeviceuser (appuserid, appdeviceid) VALUES ($appuserid,$appdeviceid) ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
        }
 
    }
    

    $out= new stdClass;
    $out->id = (integer)$appuserid;
    $out->sessionid = $sessionid;
    $out->validthru = $vt;
    $out->name = $name;
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>

